#!/bin/sh

MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_OK=0
MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ERROR=1
MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=${MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ERROR}

MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG=""

master_page_nat_dhcp_or_static() {
	debug_print "in function '${FUNCNAME[0]}'"
	
    # assign default value
    [ -z "${RT_NAT_IP}" ]      && RT_NAT_IP="${conf_nat_ip}"
    [ -z "${RT_NAT_NETMASK}" ] && RT_NAT_NETMASK="${conf_nat_netmask}"
    [ -z "${RT_NAT_DNS}" ]     && RT_NAT_DNS="${conf_nat_dns}"
    [ -z "${RT_NAT_GATEWAY}" ] && RT_NAT_GATEWAY="${conf_nat_gateway}"
    
	tp_dhcp_or_static \
		"${MASTER_PAGE_NAT_DHCP_OR_STATIC_TITLE}" \
		"${MASTER_PAGE_NAT_DHCP_OR_STATIC_TEXT}" \
		"${MASTER_PAGE_NAT_DHCP_OR_STATIC_LABEL_OK}" \
		"${MASTER_PAGE_NAT_DHCP_OR_STATIC_LABEL_CANCEL}"


	debug_print "TP_DHCP_OR_STATIC_RESULT_CODE: ${TP_DHCP_OR_STATIC_RESULT_CODE}"
    case "${TP_DHCP_OR_STATIC_RESULT_CODE}" in
    
        "${TP_DHCP_OR_STATIC_RESULT_ERROR}")
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ERROR
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG=""
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
            return
            ;;
        
        "${TP_DHCP_OR_STATIC_RESULT_CANCEL}")
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_OK
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG=""
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=-1
            return
            ;;
            
        "${TP_DHCP_OR_STATIC_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ERROR
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG="${ERROR_UNKNOWN}"
            MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
            return
            ;;
    esac
   
   
	case "${TP_DHCP_OR_STATIC_RESULT_SELECT}" in
	
		# user choose "use static ip"
		"${TP_DHCP_OR_STATIC_RESULT_STATIC}")
			RT_NAT_DHCP=0
			
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_OK
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=1
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG=""
			;;
		
		# user choose "use DHCP"
		"${TP_DHCP_OR_STATIC_RESULT_DHCP}")
			RT_NAT_DHCP=1
			
			# apply and error handling
			utility_apply_nat_network_conf "${RT_NAT_DHCP}" "" "" "" ""
			if [ "${?}" -ne 0 ]; then
				MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ERROR
				MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
				MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG="${MASTER_PAGE_NAT_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF}: ${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_MSG}"
				return
			fi

            # save to database
            RT_NAT_IP="${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_IP}"
            RT_NAT_NETMASK="${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_NETMASK}"
            RT_NAT_GATEWAY="${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_GATEWAY}"
            RT_NAT_DNS="${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_DNS}"
            utility_save_nat_network_conf \
                "${RT_NAT_DHCP}" \
                "${RT_NAT_IP}" \
                "${RT_NAT_NETMASK}" \
                "${RT_NAT_GATEWAY}" \
                "${RT_NAT_DNS}"
            if [ "${?}" -ne 0 ]; then
				MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ERROR
				MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
				MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG="${MASTER_PAGE_NAT_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_NAT_NETWORK_CONF_RESULT_MSG}"
				return
            fi
            
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_OK
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=2
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG=""
			;;
		
		*)
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ERROR
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_MSG="${ERROR_UNKNOWN}"
			MASTER_PAGE_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
			;;
	esac
}
